import { Link, useLocation } from 'react-router-dom'
import { Calendar, PlusCircle, Facebook, Instagram, Twitter, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="layout">
      <header className="header">
        <div className="header-content">
          <h1 className="logo">FitFlow</h1>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              <Calendar className="nav-icon" size={20} />
              <span>Мои записи</span>
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              <PlusCircle className="nav-icon" size={20} />
              <span>Записаться</span>
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-content">
          <div className="footer-section">
            <div className="footer-logo">
              <h2>FitFlow</h2>
            </div>
            <p className="footer-description">
              Профессиональный фитнес-центр для достижения ваших целей. 
              Мы помогаем вам стать лучше каждый день уже более 10 лет.
            </p>
            <div className="social-links">
              <a href="#" className="social-link" aria-label="Facebook">
                <Facebook className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Instagram">
                <Instagram className="social-icon" size={20} />
              </a>
              <a href="#" className="social-link" aria-label="Twitter">
                <Twitter className="social-icon" size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Услуги</h3>
            <ul className="footer-links">
              <li><Link to="/book">Записаться на тренировку</Link></li>
              <li><a href="#">Йога</a></li>
              <li><a href="#">Кроссфит</a></li>
              <li><a href="#">Пилатес</a></li>
              <li><a href="#">Стретчинг</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Информация</h3>
            <ul className="footer-links">
              <li><a href="#">О нас</a></li>
              <li><a href="#">Тренеры</a></li>
              <li><a href="#">Отзывы</a></li>
              <li><a href="#">Новости</a></li>
              <li><a href="#">Вакансии</a></li>
            </ul>
          </div>
          <div className="footer-section">
            <h3 className="footer-title">Контакты</h3>
            <div className="footer-contact">
              <div className="contact-item">
                <Phone className="contact-icon" size={18} />
                <span>+7 (495) 123-45-67</span>
              </div>
              <div className="contact-item">
                <Mail className="contact-icon" size={18} />
                <span>info@fitflow.ru</span>
              </div>
              <div className="contact-item">
                <MapPin className="contact-icon" size={18} />
                <span>г. Москва, ул. Фитнесная, д. 10</span>
              </div>
              <div className="contact-item">
                <Clock className="contact-icon" size={18} />
                <span>Пн-Вс: 7:00 - 23:00</span>
              </div>
            </div>
          </div>
        </div>
        <div className="footer-bottom">
          <p>&copy; 2025 FitFlow. Все права защищены.</p>
          <div className="footer-legal">
            <a href="#">Политика конфиденциальности</a>
            <span>|</span>
            <a href="#">Условия использования</a>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

